<!-- This will show during mpesa checkout waiting page. -->
<!DOCTYPE html>
<html>

<head>
    <title>
        <?php echo e(__("Payment in process please do not refresh page")); ?>

    </title>
    <link rel="stylesheet" href="<?php echo e(url("css/bootstrap.min.css")); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
</head>

<body>
    <br>
    <br>
    <center>
        <h1><?php echo e(__("Your transaction is being processed!!!")); ?></h1>
    </center>
    <center>
        <h4><?php echo e(__("Please do not refresh this page...")); ?></h4>
    </center>
    <center>
        <h4><?php echo e(__("Checkout ID :")); ?> <?php echo e(strip_tags($checkoutid)); ?> </h4>
    </center>
    <center>
        <h6><?php echo e(__("Getting payment status for ")); ?> <?php echo e(strip_tags($checkoutid)); ?> </h6>
    </center>

    <div class="mt-2 mb-2">
        <h5 class="payment_status text-primary text-center">
            <?php echo e(__("Awaiting payment status....")); ?>

        </h5>
    </div>

    <div class="container">
        <div class="progress">
            <div class="progress-bar progress-bar-striped bg-success progress-bar-animated" role="progressbar"
                aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: 99%"></div>
        </div>
    </div>
    <br>
    <center>
        <h6 class="text-secondary"><?php echo e(__("Page will automatically expires within 1 min if no response received.")); ?>

        </h6>
    </center>
    <br>
    <div class="text-center">
        <a href="<?php echo e(route('cart.show')); ?>" role="button" class="btn btn-md btn-danger text-center">
            <?php echo e(__("Cancel Payment")); ?>

        </a>
    </div>
    <script src="<?php echo e(url('js/jquery-2.min.js')); ?>"></script>
   
    <script>
        var orderreviewUrl = <?php echo json_encode(route("cart.show"), 15, 512) ?>;
        var verifypaymentUrl = <?php echo json_encode(route('verify.mpesa', $checkoutid), 512) ?>;
        var ordersuccessUrl = <?php echo json_encode(url("/confirmation"), 15, 512) ?>;
        var orderIssuccessUrl = <?php echo json_encode(url("/confirmation"), 15, 512) ?>;
    </script>
    <script src="<?php echo e(Module::asset('mpesa:js/ampesawait.js')); ?>"></script>
</body>

</html><?php /**PATH /home/elimun/public_html/dev/Modules/MPesa/Resources/views/front/await.blade.php ENDPATH**/ ?>