
<?php $__env->startSection('title', 'Ebook'); ?>
<?php $__env->startSection('content'); ?>

<?php echo $__env->make('admin.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php
$gets = App\Breadcum::first();
?>
<?php if(isset($gets)): ?>
<section id="business-home" class="business-home-main-block">
    <div class="business-img">
        <?php if($gets['img'] !== NULL && $gets['img'] !== ''): ?>
        <img src="<?php echo e(url('/images/breadcum/'.$gets->img)); ?>" class="img-fluid" alt="" />
        <?php else: ?>
        <img src="<?php echo e(Avatar::create($gets->text)->toBase64()); ?>" alt="<?php echo e(__('course')); ?>" class="img-fluid">
        <?php endif; ?>
    </div>
    <div class="overlay-bg"></div>
    <div class="container-xl">
        <div class="business-dtl">
            <div class="row">
                <div class="col-lg-6 col-md-5">
                    <div class="bredcrumb-dtl">
                        <h1 class="wishlist-home-heading"><?php echo e(__('Ebook')); ?></h1>
                    </div>
                </div>
                <div class="col-lg-6 col-md-7">
                    <div class="ebook-search">
                        <form method="GET" id="searchform" action="<?php echo e(route('web.ebook.search')); ?>" class="float-right">
                            <div class="search">
                                <input type="text" name="search" class="searchTerm"
                                    placeholder="<?php echo e(__('Search Ebook')); ?>">
                                <button type="submit" class="searchButton"><?php echo e(__('Search')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<section id="ebook" class="ebook-main-block">
    <div class="container-xl">
        <div class="row">
            <div class="col-lg-3 col-md-4">
                <div id="accordion">
                    <div class="card">
                        <div class="card-header" data-toggle="collapse" href="#collapseOne" data-closetxt="Stäng block" data-opentxt="Visa innehåll">
                            <a class="card-title">
                                <?php echo e(__('Categories')); ?>

                            </a>
                        </div>
                        <div id="collapseOne" class="collapse show" data-parent="">
                            <div class="card-body">
                                <div class="wrapper-two center-block">
                                    
                                    <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="panel panel-default">
                                            <div class="panel-heading active" role="tab" id="headingOnexxx">
                                                <h4 class="panel-title">
                                                    <?php if($category_id==$cate->id): ?>
                                                    <a role="button" href="<?php echo e(url('filter/category/'.$cate->id)); ?>">
                                                        <i class="fa <?php echo e($cate->image); ?> rgt-10"></i><label class="prime-cat text-success"><?php echo e(str_limit($cate->title, $limit = 20, $end = '..')); ?></label>
                                                    </a>
                                                    <?php else: ?> 
                                                    <a role="button" href="<?php echo e(url('filter/category/'.$cate->id)); ?>">
                                                        <i class="fa <?php echo e($cate->image); ?> rgt-10"></i><label class="prime-cat"><?php echo e(str_limit($cate->title, $limit = 20, $end = '..')); ?></label>
                                                    </a>
                                                    <?php endif; ?>
                                                </h4>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="col-lg-9 col-md-8">
                <div class="ebook-block">
                    <div class="row">
                        <?php if(count($ebooks)>0): ?>                        
                        <?php
		            		$currency = App\Currency::where('default', '=', '1')->first();
                        ?>
                        <?php $__currentLoopData = $ebooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-md-6">
                            <a href="<?php echo e(url('web/ebook/detail/'.$item->id)); ?>">
                                <div class="ebook-card">
                                    <div class="ebook-img text-center">
                                        <img src="<?php echo e(url('images/ebook/'.$item->thumbnali)); ?>" class="img-fluid" alt="">
                                    </div>
                                    <div class="ebook-title text-left view-dtl">
                                        <a href="<?php echo e(url('web/ebook/detail/'.$item->id)); ?>" title=""><h5 class="mb-2"><?php echo e($item->title); ?></h5></a>
                                        <div class="user-name">
                                            <h6>By <span><a href="<?php echo e(url('web/ebook/detail/'.$item->id)); ?>"><?php echo e($item->user_id?$item->user->fname:''); ?> <?php echo e($item->user_id?$item->user->lname:''); ?></a></span></h6>
                                        </div>
                                        <div class="view-footer ebook-price">
                                            <div class="row">
                                                <div class="col-lg-6"></div>
                                                <div class="col-lg-6">
                                                    <div class="rate text-right">
                                                        <ul>
                                                            <?php if($item->free=='Yes'): ?>
                                                                <li><a class="rate"><b>Free</b></a></li>
                                                            <?php else: ?>
                                                                <?php if($item->discount_check=='Yes'): ?>
                                                                <li><a class="rate"><b><?php echo e(currency($item->discount_price, $from = $currency->code, $to = $currency->code, $format = true)); ?></b></a></li>
                                                                <li><a><strike><?php echo e(currency($item->price, $from = $currency->code, $to = $currency->code, $format = true)); ?></strike></a></li>
                                                                <?php else: ?>
                                                                <li><a class="rate"><b><?php echo e(currency($item->price, $from = $currency->code, $to = $currency->code, $format = true)); ?></b></a></li>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="img-wishlist ebook-buy-view-btn">
                                            <div class="protip-wishlist">
                                                <ul>
                                                    <!-- <li class="protip-wish-btn"><a href="<?php echo e(url('web/ebook/addtocart/'.$item->id)); ?>" title="Add TO Cart"><i data-feather="shopping-cart"></i></a></li> -->
                                                    <li class="protip-wish-btn"><a href="<?php echo e(url('web/ebook/detail/'.$item->id)); ?>" title="View"><i data-feather="eye"></i></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                        <?php else: ?> 
                        <div class="col-lg-12">
                            <div class="data-not-found">
                                <div class="text-center">
                                    <h5>No Data Found!</h5>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('theme.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elimun/public_html/Modules/Ebook/Resources/views/web/ebook_list.blade.php ENDPATH**/ ?>