
<?php $__env->startSection('title', 'Chat - Admin'); ?>
<?php $__env->startSection('maincontent'); ?>
<?php
$data['heading'] = 'Chat';
$data['title'] = 'Chat';
?>
<?php echo $__env->make('admin.layouts.topbar',$data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="contentbar">
    <div class="row">
        <div class="col-lg-12">
            <div class="chat-main-block">
                <div class="card dashboard-card m-b-30">
                    <div class="card-header">
                        <h5 class="card-title"><i class="feather icon-message-circle"></i>My Chats (<?php echo e($conversations->count()); ?>)</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-8 col-md-12">
                                <?php $__empty_1 = true; $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="shadow-sm card mb-3 border chat-conversation">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="chat-conversation-block">
                                                    <h5 class="box-title">Conversation ID</h5>
                                                    <a href="<?php echo e(route('chat.screen',$chat->conv_id)); ?>"><?php echo e($chat->conv_id); ?></a>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="chat-conversation-block">
                                                    <h5 class="box-title">Conversation with</h5>
                                                    <p><?php echo e($chat->sender_id == auth()->id() ? $chat->reciever->fname.' '.$chat->reciever->lname : $chat->sender->fname.' '.$chat->sender->lname); ?></p>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="chat-conversation-block">
                                                    <h5 class="box-title">Last Message</h5>
                                                    <span> <b><?php echo e(!empty( $chat->chat->last() ) ? $chat->chat->last()->message : "No "); ?></b> <?php echo e(__('from')); ?> <?php echo e(!empty( $chat->chat->last() ) ? $chat->chat->last()->user->name : ''); ?> - <?php echo e(!empty( $chat->chat->last() ) ? $chat->chat->last()->created_at->format('jS M Y - h:i A') : ''); ?> </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <h4 class="no_conv text-center text-muted">
                                    <i class="feather icon-message-circle"></i> <?php echo e(__("Start a new conversation")); ?>

                                </h4>
                                <?php endif; ?>
                            </div>
                            <div class="col-lg-4 col-md-12">
                                <div class="chat-list">
                                    <div class="chat-search">
                                        <form>
                                            <div class="input-group">
                                                <input type="search" class="form-control" placeholder="Search" name="user" aria-label="Search" aria-describedby="button-addon3">
                                                <div class="input-group-append">
                                                <button class="btn" type="submit" id="button-addon3"><i class="feather icon-search"></i></button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="chat-user-list scroll-down">
                                        <ul class="list-unstyled mb-0">
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('chat.start',$user->id)); ?>">
                                                <li class="media">
                                                    <?php if($user->user_img != '' && file_exists(public_path().'/images/user_img/'.$user->user_img)): ?>
                                                        <img class="align-self-center mr-3 rounded-circle" src="<?php echo e(url('images/user_img/'.$user->user_img)); ?>"/>
                                                    <?php else: ?> 
                                                        <img class="align-self-center mr-3 rounded-circle" src="<?php echo e(Avatar::create($user->fname)->toBase64()); ?>"/>
                                                    <?php endif; ?>
                                                    <div class="media-body">
                                                        <h5><?php echo e($user->fname); ?> <?php echo e($user->lname); ?></h5>
                                                        <p><?php echo e(ucfirst($user->role)); ?></p>
                                                    </div>
                                                </li>
                                            </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elimun/public_html/Modules/Chatboard/Resources/views/chat/chat_list.blade.php ENDPATH**/ ?>