
# Order Fulfillment

Contains details about how to fulfill this order.

## Structure

`OrderFulfillment`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `uid` | `?string` | Optional | A unique ID that identifies the fulfillment only within this order.<br>**Constraints**: *Maximum Length*: `60` | getUid(): ?string | setUid(?string uid): void |
| `type` | [`?string (OrderFulfillmentType)`](/doc/models/order-fulfillment-type.md) | Optional | The type of fulfillment. | getType(): ?string | setType(?string type): void |
| `state` | [`?string (OrderFulfillmentState)`](/doc/models/order-fulfillment-state.md) | Optional | The current state of this fulfillment. | getState(): ?string | setState(?string state): void |
| `metadata` | `?array` | Optional | Application-defined data attached to this fulfillment. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (such as personally<br>identifiable information or card details).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries can also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a maximum length of 255 characters.<br><br>An application can have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>For more information, see [Metadata](https://developer.squareup.com/docs/build-basics/metadata). | getMetadata(): ?array | setMetadata(?array metadata): void |
| `pickupDetails` | [`?OrderFulfillmentPickupDetails`](/doc/models/order-fulfillment-pickup-details.md) | Optional | Contains details necessary to fulfill a pickup order. | getPickupDetails(): ?OrderFulfillmentPickupDetails | setPickupDetails(?OrderFulfillmentPickupDetails pickupDetails): void |
| `shipmentDetails` | [`?OrderFulfillmentShipmentDetails`](/doc/models/order-fulfillment-shipment-details.md) | Optional | Contains the details necessary to fulfill a shipment order. | getShipmentDetails(): ?OrderFulfillmentShipmentDetails | setShipmentDetails(?OrderFulfillmentShipmentDetails shipmentDetails): void |

## Example (as JSON)

```json
{
  "uid": "uid0",
  "type": "PICKUP",
  "state": "PREPARED",
  "metadata": {
    "key0": "metadata3",
    "key1": "metadata4",
    "key2": "metadata5"
  },
  "pickup_details": {
    "recipient": {
      "customer_id": "customer_id8",
      "display_name": "display_name0",
      "email_address": "email_address8",
      "phone_number": "phone_number8",
      "address": {
        "address_line_1": "address_line_16",
        "address_line_2": "address_line_26",
        "address_line_3": "address_line_32",
        "locality": "locality6",
        "sublocality": "sublocality6"
      }
    },
    "expires_at": "expires_at2",
    "auto_complete_duration": "auto_complete_duration2",
    "schedule_type": "SCHEDULED",
    "pickup_at": "pickup_at6"
  }
}
```

