
# Create Card Request

Creates a card from the source (nonce, payment id, etc). Accessible via
HTTP requests at POST https://connect.squareup.com/v2/cards

## Structure

`CreateCardRequest`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `idempotencyKey` | `string` | Required | A unique string that identifies this CreateCard request. Keys can be<br>any valid string and must be unique for every request.<br><br>Max: 45 characters<br><br>See [Idempotency keys](https://developer.squareup.com/docs/basics/api101/idempotency) for more information.<br>**Constraints**: *Minimum Length*: `1` | getIdempotencyKey(): string | setIdempotencyKey(string idempotencyKey): void |
| `sourceId` | `string` | Required | The ID of the source which represents the card information to be stored. This can be a card nonce or a payment id.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `16384` | getSourceId(): string | setSourceId(string sourceId): void |
| `verificationToken` | `?string` | Optional | An identifying token generated by [Payments.verifyBuyer()](https://developer.squareup.com/reference/sdks/web/payments/objects/Payments#Payments.verifyBuyer).<br>Verification tokens encapsulate customer device information and 3-D Secure<br>challenge results to indicate that Square has verified the buyer identity.<br><br>See the [SCA Overview](https://developer.squareup.com/docs/sca-overview). | getVerificationToken(): ?string | setVerificationToken(?string verificationToken): void |
| `card` | [`Card`](/doc/models/card.md) | Required | Represents the payment details of a card to be used for payments. These<br>details are determined by the payment token generated by Web Payments SDK. | getCard(): Card | setCard(Card card): void |

## Example (as JSON)

```json
{
  "card": {
    "billing_address": {
      "address_line_1": "500 Electric Ave",
      "address_line_2": "Suite 600",
      "administrative_district_level_1": "NY",
      "country": "US",
      "locality": "New York",
      "postal_code": "10003"
    },
    "cardholder_name": "Amelia Earhart",
    "customer_id": "VDKXEEKPJN48QDG3BGGFAK05P8",
    "reference_id": "user-id-1"
  },
  "idempotency_key": "4935a656-a929-4792-b97c-8848be85c27c",
  "source_id": "cnon:uIbfJXhXETSP197M3GB"
}
```

